using inetsoftware.Pdfc;
using inetsoftware.Pdfc.Presenter;
using System;
using System.Collections.Generic;

namespace inetsoftware.PdfcSamples
{
    /// <summary>
    /// A sample for printing the result of the comparison of 2 PDF files
    /// with some print settings
    /// Expected 2 arguments, the path of the PDF files
    /// </summary>
    public class CompareAndPrintWithPrintsetting
    {
        static CompareAndPrintWithPrintsetting()
        {
            // Activate the license once from environment if required.
            string key = Environment.GetEnvironmentVariable("PDFC_KEY");
            if (!string.IsNullOrEmpty(key))
            {
                PDFC.ActivateLicense(key);
            }
        }

        /// <summary>
        /// Start the sample, to show the printing function of the result of comparison between 2 PDF files
        /// with some print settings
        /// </summary>
        /// <param name="args">Expected 2 arguments, the path of the PDF files</param>
        public static void Main(string[] args)
        {
            if (args == null || args.Length != 2)
            {
                throw new ArgumentException("Usage: <executable> <PDF-File1> <PDF-File2>");
            }

            //set up Printer service
            IDictionary<string,string> attributes = new Dictionary<string, string>();
            //use a specific printer instead the default printer
            attributes.Add("PrinterName", "CutePDF Writer");
            //select paper A4
            attributes.Add("MediaSizeName", "ISO_A4");
            //select orientation landscape
            attributes.Add("OrientationRequested", "PORTRAIT");

            using (new PDFComparer()
                            .AddPresenter(new DifferencesPrintPresenter(attributes))
                            .Compare(args[0], args[1]))
            { }
        }
    }
}